/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.MineTogetherServer;
import net.creeperhost.minetogether.lib.web.ApiClientResponse;
import net.creeperhost.minetogether.lib.web.ApiResponse;
import net.creeperhost.minetogether.server.web.SendInviteRequest;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandInvite {
    private static final Logger LOGGER = LogManager.getLogger();

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"invite").requires(cs -> cs.m_6761_(3))).then(Commands.m_82129_((String)"username", (ArgumentType)StringArgumentType.string()).executes(cs -> CommandInvite.execute((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"username"))));
    }

    private static int execute(CommandContext<CommandSourceStack> cs, String username) {
        MinecraftServer minecraftServer = ((CommandSourceStack)cs.getSource()).m_81377_();
        if (username.isEmpty()) {
            throw new CommandRuntimeException((Component)new TranslatableComponent("Invalid username"));
        }
        GameProfile gameProfile = (GameProfile)minecraftServer.m_129927_().m_10996_(username).get();
        if (gameProfile == null) {
            throw new CommandRuntimeException((Component)new TranslatableComponent("Failed to load GameProfile, Username is not valid"));
        }
        if (minecraftServer.m_6846_().m_11305_().m_11453_(gameProfile)) {
            throw new CommandRuntimeException((Component)new TranslatableComponent(username + " Is already whitelisted"));
        }
        UserWhiteListEntry userWhiteListEntry = new UserWhiteListEntry(gameProfile);
        minecraftServer.m_6846_().m_11305_().m_11381_((StoredUserEntry)userWhiteListEntry);
        minecraftServer.m_6846_().m_7542_();
        CommandInvite.sendUserInvite(gameProfile, minecraftServer);
        ((CommandSourceStack)cs.getSource()).m_81354_((Component)new TranslatableComponent(username + " Added to whitelist"), false);
        return 0;
    }

    public static void sendUserInvite(GameProfile profile, MinecraftServer server) {
        UserWhiteList whitelistedPlayers = server.m_6846_().m_11305_();
        ArrayList<String> tempHash = new ArrayList<String>();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(((UserWhiteListEntry)whitelistedPlayers.m_11388_((Object)profile)).toString().getBytes(StandardCharsets.UTF_8));
            tempHash.add(Arrays.toString(digest.digest(hash)));
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.fatal("SHA256 not supported??", (Throwable)ex);
        }
        try {
            ApiClientResponse<ApiResponse> resp = MineTogether.API.execute(new SendInviteRequest(MineTogetherServer.inviteId, tempHash));
            LOGGER.debug("Response from add endpoint " + resp.apiResponse().getStatus() + " " + resp.apiResponse().getMessageOrNull());
        }
        catch (IOException e) {
            LOGGER.error("Failed to send invite.");
        }
    }
}

